<?php

include_once("func_pm.inc.php");
include_once("class_turniere.php");

function makeborderbox( $headline )
{
    echo '<table border="1" cellpadding="0" cellspacing="1" width="250">';
    echo '  <tr>';
    echo '    <td align="center">';
    echo '      <table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td>';
    echo '      <table border="0" cellpadding="1" cellspacing="1" width="100%">';
    echo '        <tr>';
    echo '          <td align="center">';
    echo '            <b>' . $headline . '</b>';
    echo '          </td>';
    echo '        </tr>';
    echo '      </table>';
    echo '      </td></tr></table>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="center">';
    echo '      <table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td>';
    echo '      <table border="0" cellpadding="1" cellspacing="1" width="100%">';
    echo '        <tr>';
    echo '          <td>';
}


function closeborderbox()
{
    echo '          </td>';
    echo '        </tr>';
    echo '      </table>';
    echo '      </td></tr></table>';
    echo '    </td>';
    echo '  </tr>';
    echo '</table>';
}

// -----------------------------------------------------------------------------


function add_credits( $user_id, $turnier_id ) //user-id und turnier-id werden �bergeben und funktion liest aus der turnier-tabelle die kosten des turniers raus und zieht sie dem user ab
{
    global $db, $cl_txl;

    $res = mysqli_query($db, "SELECT credits from txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_credits = $row["credits"];

    $res = mysqli_query($db, "SELECT credits from txl_lans WHERE com_user_id = $user_id AND lan_nr = $cl_txl");
    $row = mysqli_fetch_array($res);
    $user_credits = $row["credits"];

    mysqli_query($db, "UPDATE txl_lans SET credits = ( $user_credits + $turnier_credits ) WHERE com_user_id = $user_id AND lan_nr = $cl_txl");
}


function sub_credits( $user_id, $turnier_id ) //user-id und turnier-id werden �bergeben und funktion liest aus der turnier-tabelle die kosten des turniers raus und schreibt sie dem user wieder gut
{
    global $db, $cl_txl;

    $res = mysqli_query($db, "SELECT credits from txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_credits = $row["credits"];

    $res = mysqli_query($db, "SELECT credits from txl_lans WHERE com_user_id = $user_id AND lan_nr = $cl_txl");
    $row = mysqli_fetch_array($res);
    $user_credits = $row["credits"];

    mysqli_query($db, "UPDATE txl_lans SET credits = ( $user_credits - $turnier_credits ) WHERE com_user_id = $user_id AND lan_nr = $cl_txl");
}


function turnier_anmelden_single( $turnier_id , $user_id , $angemeldet )
{
    global $db, $cl_txl;

    if ( $angemeldet == 0 && check_credits( $user_id, $turnier_id ) == 1 )
    {
        mysqli_query($db, "INSERT INTO txl_turniere_teilnehmer ( id , turnier_id , teilnehmer_id ) VALUES ( '' , '$turnier_id' , '$user_id' )");
        sub_credits( $user_id, $turnier_id );
    }
}

function turnier_abmelden_single( $turnier_id , $user_id , $angemeldet )
{
    global $db, $cl_txl;

    if ( $angemeldet == 1 )
    {
        mysqli_query($db, "DELETE FROM txl_turniere_teilnehmer WHERE teilnehmer_id = $user_id AND turnier_id = $turnier_id");
        add_credits( $user_id, $turnier_id );
    }
}


function turnier_anmelden_multi( $team_id )
{
	global $db;
	
	mysqli_query($db, "UPDATE txl_turniere_teams SET gemeldet = 1 WHERE id = $team_id");
}


function turnier_abmelden_multi( $team_id )
{
	global $db;

	mysqli_query($db, "UPDATE txl_turniere_teams SET gemeldet = 0 WHERE id = $team_id");
}


function turnierinfo_single( $turnier_id, $user_id ,$angemeldet, $user_status )
{
    global $db, $cl_txl;

    $res = mysqli_query($db, "SELECT credits FROM txl_lans WHERE lan_nr = $cl_txl AND com_user_id = $user_id");
    $row = mysqli_fetch_array($res);
    $user_credits = $row["credits"];

    $res = mysqli_query($db, "SELECT credits FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_credits = $row["credits"];

    if ( $user_status >= 2 )    // User hat schon bezahlt
    {
        if ( $angemeldet == 0 ) // bezahlt: JA, angemeldet: NEIN
        {
            if ( !isset($_GET["submod"]) )
            {
                makeborderbox( "Info" );
                show_credits( $user_id );
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "teilnehmerliste" )
            {
                makeborderbox( "Teilnehmerliste" );
                show_turnier_teilnehmer( $turnier_id );
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "anmelden" )
            {
                if ( check_turnier_single( $user_id, $turnier_id ) == 1 )
                {
                    makeborderbox( "Anmeldung" );
                    show_anmeldetext_single( $user_credits, $turnier_credits );
                    closeborderbox();
                }
                else
                {
                    makeborderbox( "Anmeldung" );
                    show_creditmangel_single( $user_credits, $turnier_credits );
                    closeborderbox();
                }
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "abmelden" )
            {
                    makeborderbox( "Abmeldung" );
                    show_abmeldetext_single( $user_credits, $turnier_credits );
                    closeborderbox();
            }
        }
        elseif ( $angemeldet == 1 ) // bezahlt: JA, angemeldet: JA
        {
            if ( !isset($_GET["submod"]) )
            {
                makeborderbox( "Info" );
                show_credits( $user_id );
                closeborderbox();
            }

            if ( isset($_GET["submod"]) && $_GET["submod"] == "teilnehmerliste" )
            {
                makeborderbox( "Teilnehmerliste" );
                show_turnier_teilnehmer( $turnier_id );
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "anmelden" )
            {
                    makeborderbox( "Anmeldung" );
                    show_anmeldetext_single( $user_credits, $turnier_credits );
                    closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "abmelden" )
            {
                    makeborderbox( "Abmeldung" );
                    show_abmeldetext_single( $user_credits, $turnier_credits );
                    closeborderbox();
            }
        }
    }
    elseif ( $user_status < 2 ) // User hat noch nicht bezahlt
    {
        if ( $angemeldet == 0 ) // bezahlt: NEIN, angemeldet: NEIN
        {
            if ( !isset($_GET["submod"]) )
            {
                makeborderbox( "Info" );
                show_error();
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "teilnehmerliste" )
            {
                makeborderbox( "Teilnehmerliste" );
                show_turnier_teilnehmer( $turnier_id );
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "anmelden" )
            {
                makeborderbox( "Info" );
                show_error();
                closeborderbox();
            }

            if (  isset($_GET["submod"]) && $_GET["submod"] == "abmelden" )
            {
                makeborderbox( "Info" );
                show_error();
                closeborderbox();
            }
        }
        elseif ( $angemeldet == 1 ) // bezahlt: NEIN, angemeldet: NEIN, dieser Fall kann nicht vorkommen!
        {
                makeborderbox( "Info" );
                show_error();
                closeborderbox();
        }
    }
}


function turnierinfo_multi( $turnier_id, $user_id, $user_status, $team_id, $team_gemeldet, $leader )
{
    global $db, $cl_txl, $rechte;

    $res = mysqli_query($db, "SELECT credits FROM txl_lans WHERE lan_nr = $cl_txl AND com_user_id = $user_id");
    $row = mysqli_fetch_array($res);
    $user_credits = $row["credits"];

    $res = mysqli_query($db, "SELECT credits FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_credits = $row["credits"];

    if ( $user_status >= 2 || $rechte[8] == 1 )    // User hat schon bezahlt
    {
        if ( !isset($_GET["submod"]) )
        {
            makeborderbox( "Info" );
            show_credits( $user_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "myteam" ) // mein Team
        {
            makeborderbox( "mein Team" );
            show_my_team( $team_id, $turnier_id, $leader, $user_id );
            closeborderbox();
        }

    	if ( isset($_GET["submod"]) && $_GET["submod"] == "teilnehmerliste" ) // Teamliste
    	{
            makeborderbox( "Teamliste" );
            show_list_teams( $turnier_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "team_create" ) // Team erstellen
        {
            if ( check_credits( $user_id, $turnier_id ) == 1 ) // genug Credits, 1
            {
                makeborderbox( "neues Team erstellen" );
                show_create_team( $turnier_id, $user_id );
                closeborderbox();
            }
            elseif ( check_turnier_multi( $user_id, $turnier_id ) == 1 ) // angemeldet, 2
            {
                makeborderbox( "neues Team erstellen" );
                show_create_team( $turnier_id, $user_id );
                closeborderbox();
            }
            else
            {
                makeborderbox( "neues Team erstellen" );
                show_creditmangel_multi( $user_credits, $turnier_credits );
                closeborderbox();
            }
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "team_del" ) // Team aufl�sen
        {
            makeborderbox( "Team aufl�sen" );
            show_del_team( $user_id, $team_id, $leader );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "team_join" ) // Team beitreten
        {
            if ( check_team_member( fetch_team_id( $turnier_id, $user_id ), $user_id ) == 1 || check_credits( $user_id, $turnier_id ) == 1 )
            {
                makeborderbox( "Team beitreten" );
                show_join_team( $user_id, $turnier_id, $team_id );
                closeborderbox();
            }
            elseif ( check_team_member( $team_id, $user_id ) == 0 )
            {
                makeborderbox( "Team beitreten" );
                show_creditmangel_multi( $user_credits, $turnier_credits );
                closeborderbox();
            }
            else
            {
                //bla <------------------------------------------------------------------
            }
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "team_leave" ) // Team verlassen
        {
            makeborderbox( "Team verlassen" );
            show_leave_team( $user_id, $turnier_id, $team_id, $leader );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "kick_member" ) // Team-Member kicken
        {
            makeborderbox( "Team-Member kicken" );
            show_kick_member( $turnier_id , $team_id, $user_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "tournament_join" && $leader == 1 ) // Team als Teamleader zum Turnier anmelden
        {
            makeborderbox( "Team anmelden" );
            show_anmeldetext_multi( $turnier_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "tournament_join" && $leader == 0 ) // Team als nicht-Teamleader zum Turnier anmelden
        {
            makeborderbox( "Team anmelden" );
            show_anmeldetext_multi_error( $turnier_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "tournament_leave" && $leader == 1 ) // Team als Teamleader vom Turnier abmelden
        {
            makeborderbox( "Team abmelden" );
            show_abmeldetext_multi( $turnier_id );
            closeborderbox();
        }

        if ( isset($_GET["submod"]) && $_GET["submod"] == "tournament_leave" && $leader == 0 ) // Team als nicht-Teamleader vom Turnier abmelden
        {
            makeborderbox( "Team abmelden" );
            show_abmeldetext_multi_error( $turnier_id );
            closeborderbox();
        }
    }
    elseif ( $user_status < 2 ) // User hat noch nicht bezahlt
    {
    	if ( isset($_GET["submod"]) && $_GET["submod"] == "teamliste" ) // Teamliste
    	{
            makeborderbox( "Teamliste" );
            show_list_teams( $turnier_id );
            closeborderbox();
        }
    }
}


//------------------------------------------------------------------------------

function fetch_team_id( $turnier_id , $user_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT team_id FROM txl_turniere_team_teilnehmer,txl_turniere_teams WHERE txl_turniere_team_teilnehmer.teilnehmer_id = $user_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_teams.turnier_id = $turnier_id");
    $row = mysqli_fetch_array($res);

//    echo "SELECT team_id FROM txl_turniere_team_teilnehmer,txl_turniere_teams WHERE txl_turniere_team_teilnehmer.teilnehmer_id = $user_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_teams.turnier_id = $turnier_id<br>";

    if ( $row["team_id"] == "" ) return -1;
    if ( $row["team_id"] != "" ) return $row["team_id"];
}


function fetch_user_credits( $user_id )
{
    global $db, $cl_txl;

    $res = mysqli_query($db, "SELECT credits FROM txl_lans WHERE com_user_id = $user_id AND lan_nr = $cl_txl");
    $row = mysqli_fetch_array($res);
    $credits = $row["credits"];

    return $credits;
}


function count_team_members( $team_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT COUNT(*) AS anzahl from txl_turniere_team_teilnehmer WHERE team_id = $team_id");
    $row = mysqli_fetch_array($res);
    $anzahl = $row["anzahl"];

    return $anzahl;
}


function count_turnier_team_members( $turnier_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT anzahl from txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $anzahl = $row["anzahl"];

    return $anzahl;
}

//------------------------------------------------------------------------------

function create_team( $turnier_id, $user_id )
{
    global $db;

    if ( isset($_POST["team_name"]) )
    {
        $team_name    = $_POST["team_name"];
        $team_pass1   = $_POST["team_pass1"];
        $team_pass2   = $_POST["team_pass2"];
        $team_ngl_id  = $_POST["team_ngl_id"];

        $res_name = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE name = '$team_name' AND turnier_id = '$turnier_id'");
        $row_name = mysqli_fetch_array($res_name);
        $anzahl_name = $row_name["anzahl"];

        $res_ngl_id = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE ngl_id = '$team_ngl_id' AND ngl_id != '' AND turnier_id = '$turnier_id'");
        $row_ngl_id = mysqli_fetch_array($res_ngl_id);
        $anzahl_ngl_id = $row_ngl_id["anzahl"];

        if ( $team_pass1 == $team_pass2 && $anzahl_name == 0 && $anzahl_ngl_id == 0 && $team_name != "" && $team_pass1 != "" )
        {
            mysqli_query($db, "INSERT INTO txl_turniere_teams ( id, name, pass, turnier_id, ngl_id, gemeldet ) VALUES ( '', '$team_name', '$team_pass1', '$turnier_id', '$team_ngl_id', '0' )");
            $team_id = mysqli_insert_id($db);
            mysqli_query($db, "INSERT INTO txl_turniere_team_teilnehmer ( id, team_id, teilnehmer_id, leader ) VALUES ( '', '$team_id', '$user_id', '1' )");
            sub_credits( $user_id, $turnier_id );
        }
    }
}


function del_team( $user_id, $team_id, $turnier_id, $leader )
{
    global $db;

	if ( $leader == 1 )
	{
	    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_team_teilnehmer WHERE team_id = $team_id");
    	$row = mysqli_fetch_array($res);
    	$anzahl = $row["anzahl"];
    	
  		if ( $anzahl == 1 ) // Team besteht nur aus Leader
  		{
  		    mysqli_query($db, "DELETE FROM txl_turniere_team_teilnehmer WHERE team_id = $team_id");
	        mysqli_query($db, "DELETE FROM txl_turniere_teams WHERE id = $team_id");
	        add_credits( $user_id, $turnier_id );
	    }
	}
}


function join_team( $turnier_id, $user_id )
{
    global $db;

    if ( isset($_POST["team_name"]) )$team_id = $_POST["team_name"];

    if ( fetch_team_id( $turnier_id , $user_id ) <= 0 && count_team_members( $team_id ) < count_turnier_team_members( $turnier_id ) )
    {
        mysqli_query($db, "INSERT INTO txl_turniere_team_teilnehmer ( id, team_id, teilnehmer_id, leader ) VALUES ( '', '$team_id', '$user_id', '0' )");
        sub_credits( $user_id, $turnier_id );
    }
}


function leave_team( $user_id, $turnier_id, $team_id )
{
    global $db;

    if ( fetch_team_id( $turnier_id, $user_id ) >= 1 && check_turnier_team( $turnier_id , $team_id, $user_id ) == 0 && check_team_leader( $team_id, $user_id ) == 0 )
    {
        mysqli_query($db, "DELETE FROM txl_turniere_team_teilnehmer WHERE teilnehmer_id = $user_id AND team_id = $team_id");
        add_credits( $user_id, $turnier_id );
    }
}


function kick_member( $kick_id, $turnier_id, $team_id, $user_id )
{
	global $db;
	
	if ( isset($_GET["kick_id"]) ) $kick_id = $_GET["kick_id"];

	if ( check_turnier_team( $turnier_id , $team_id, $user_id ) == 0 && check_team_leader( $team_id, $user_id ) == 1 )
	{
		mysqli_query($db, "DELETE FROM txl_turniere_team_teilnehmer WHERE teilnehmer_id = $kick_id AND team_id = $team_id");
    	add_credits( $kick_id, $turnier_id );
	}
}

// -----------------------------------------------------------------------------

function check_credits( $user_id, $turnier_id )
{
    global $db, $cl_txl;

    $res = mysqli_query($db, "SELECT credits FROM txl_lans WHERE lan_nr = $cl_txl AND com_user_id = $user_id");
    $row = mysqli_fetch_array($res);
    $user_credits = $row["credits"];

    $res = mysqli_query($db, "SELECT credits FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_credits = $row["credits"];
/*
    echo 'user_id: ' . $user_id . '<br>';
    echo 'turnier_id: ' . $turnier_id . '<br>';
    echo 'user_credits: ' . $user_credits . '<br>';
    echo 'turnier_credits: ' . $turnier_credits . '<br>';
    echo 'rest: ' . ( $user_credits - $turnier_credits ) . '<br>';
*/

    if ( $user_credits - $turnier_credits >= 0 )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


function check_team_leader( $team_id, $user_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT leader FROM txl_turniere_team_teilnehmer WHERE team_id = $team_id AND teilnehmer_id = $user_id");
    $row = mysqli_fetch_array($res);

    if ( $row["leader"] == 1 ) return 1;
    if ( $row["leader"] != 1 ) return 0;
}


function check_team_member( $team_id, $user_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT COUNT(*) AS anzahl FROM txl_turniere_team_teilnehmer WHERE team_id = $team_id AND teilnehmer_id = $user_id");
    $row = mysqli_fetch_array($res);

    if ( $row["anzahl"] == 1 ) return 1;
    if ( $row["anzahl"] != 1 ) return 0;
}


function check_team_pw()
{
    global $db;

    if ( isset($_POST["team_name"]) ) $team_id = $_POST["team_name"];
    if ( isset($_POST["team_pass"]) ) $user_pw = $_POST["team_pass"];

    $res = mysqli_query($db, "SELECT pass FROM txl_turniere_teams WHERE id = $team_id");
    $row = mysqli_fetch_array($res);
    $team_pw = $row["pass"];

    if ( $user_pw == $team_pw ) return 1;
    if ( $user_pw != $team_pw ) return 0;
}


function check_turnier_anmeldung( $turnier_id , $user_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teilnehmer WHERE turnier_id = $turnier_id AND teilnehmer_id = $user_id");
    $row = mysqli_fetch_array($res);

    if ( $row["anzahl"] >= 1 ) return 1;
    if ( $row["anzahl"] == 0 ) return 0;
}


function check_turnier_single( $user_id, $turnier_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere, txl_turniere_teilnehmer WHERE txl_turniere.id = txl_turniere_teilnehmer.turnier_id AND txl_turniere.id = $turnier_id AND teilnehmer_id = $user_id");
    $row = mysqli_fetch_array($res);
    if ( $row["anzahl"] >= 1 )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


function check_turnier_multi( $user_id, $turnier_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere, txl_turniere_teams, txl_turniere_team_teilnehmer WHERE txl_turniere.id = txl_turniere_teams.turnier_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere.id = $turnier_id AND teilnehmer_id = $user_id");
    $row = mysqli_fetch_array($res);
    if ( $row["anzahl"] >= 1 )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


function check_turnier_team( $turnier_id , $team_id, $user_id )
{
    global $db;

    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams, txl_turniere_team_teilnehmer WHERE turnier_id = $turnier_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_team_teilnehmer.teilnehmer_id = $user_id AND gemeldet = 1");
    $row = mysqli_fetch_array($res);

    if ( $row["anzahl"] >= 1 ) return 1;
    if ( $row["anzahl"] == 0 ) return 0;
}

//------------------------------------------------------------------------------

function show_anmeldetext_single( $user_credits, $turnier_credits )
{
    echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '      <u>Du hast dich erfolgreich angemeldet!</u><br><br><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Credits vorher</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits + $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Kosten f�r dieses Turnier</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo ' - ' . $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '<hr width="100%">';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>verbleibende Credits</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '</table></center><br><br>';
}


function show_abmeldetext_single( $user_credits, $turnier_credits )
{
    echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '      <u>Du hast dich erfolgreich abgemeldet!</u><br><br><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Credits vorher</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits - $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Gutschrift f�r dieses Turnier</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo ' + ' . $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '<hr width="100%">';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>aktuelle Credits</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '</table></center><br><br>';
}


function show_anmeldetext_multi( $turnier_id )
{
	global $db;

    $res = mysqli_query($db, "SELECT name AS turnier_name FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_name = $row["turnier_name"];

    echo '<br><center>';
	echo 'Du hast dein Team gerade<br>';
	echo 'zum <b>' . $turnier_name . '</b> angemeldet.<br><br>';
	echo 'Weitere Infos ( Turnierbeginn,<br>';
	echo 'n�chster Gegner, Rundenbeginn )<br>';
	echo 'erh�lts du per PM.<br><br>';
	echo 'Wenn einer deiner Team-Member<br>';
	echo 'dein Team verlassen m�chte,<br>';
	echo 'musst du das Team erst vom Turnier<br>';
	echo 'abmelden. Aber Vorsicht: Wenn dein<br>';
	echo 'Team zu Turnierbeginn nicht wieder<br>';
	echo 'vollst�ndig und zum Turnier erneut<br>';
	echo 'angemeldet ist, kann es nicht am<br>';
	echo 'Turnier teilnehmen.<br>';
    echo '<br></center>';
}

function show_abmeldetext_multi( $turnier_id )
{
	global $db;

    $res = mysqli_query($db, "SELECT name AS turnier_name FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_name = $row["turnier_name"];

    echo '<br><center>';

	echo 'Du hast dein Team gerade<br>';
	echo 'vom <b>' . $turnier_name . '</b> abgemeldet.<br><br>';
	echo 'Wenn dein Team bis zum Turnierbeginn<br>';
	echo 'nicht vollst�ndig und zum Turnier erneut<br>';
	echo 'angemeldet ist, kann es nicht am<br>';
	echo 'Turnier teilnehmen.<br>';
    echo '<br></center>';
}

function show_anmeldetext_multi_error( $turnier_id )
{
	global $db;

    $res = mysqli_query($db, "SELECT name AS turnier_name FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_name = $row["turnier_name"];

    echo '<br><center>';

	echo 'Sorry, du kannst dieses team<br>';
	echo 'nicht zum <b>' . $turnier_name . '</b>';
	echo 'anmelden, da du nicht der<br>';
	echo 'Team-Leader dieses Teams bist.<br>';
    echo '<br></center>';
}

function show_abmeldetext_multi_error( $turnier_id )
{
	global $db;

    $res = mysqli_query($db, "SELECT name AS turnier_name FROM txl_turniere WHERE id = $turnier_id");
    $row = mysqli_fetch_array($res);
    $turnier_name = $row["turnier_name"];

    echo '<br><center>';

	echo 'Sorry, du kannst dieses team<br>';
	echo 'nicht zum <b>' . $turnier_name . '</b>';
	echo 'abmelden, da du nicht der<br>';
	echo 'Team-Leader dieses Teams bist.<br>';
    echo '<br></center>';
}

function show_create_team( $turnier_id, $user_id )
{
    global $db;

    if ( !isset($_POST["team_name"]) )
    {
        echo '<form action="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_create" method="post">';
        echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Team-Name: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <input type="text" size="10" name="team_name">';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Team-Passwort: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <input type="password" size="10" name="team_pass1">';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Passwortwiederholung: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <input type="password" size="10" name="team_pass2">';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Team-NGL-ID: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <input type="text" size="10" name="team_ngl_id">';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td colspan="2" align="center">';
        echo '      <br><input type="submit" class="button" value="Team anlegen">';
        echo '    </td>';
        echo '  </tr>';
        echo '</table></center></form><br>';
    }
    else
    {
        if ( isset($_POST["team_name"]) ) $team_name    = $_POST["team_name"];
        if ( isset($_POST["team_pass1"]) ) $team_pass1   = $_POST["team_pass1"];
        if ( isset($_POST["team_pass2"]) ) $team_pass2   = $_POST["team_pass2"];
        if ( isset($_POST["team_ngl_id"]) ) $team_ngl_id = $_POST["team_ngl_id"];

        $res_name = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE name = '$team_name'");
        $row_name = mysqli_fetch_array($res_name);
        $anzahl_name = $row_name["anzahl"];

        $res_ngl_id = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE ngl_id = '$team_ngl_id' AND ngl_id != ''");
        $row_ngl_id = mysqli_fetch_array($res_ngl_id);
        $anzahl_ngl_id = $row_ngl_id["anzahl"];

        if ( fetch_team_id( $turnier_id , $user_id ) >= 1 )
        {
            echo '<br><center>';
            echo 'Du hast ein Team angelegt<br>';
            echo 'und bist Teamleader.<br><br>';
            echo 'Sobald dieses Team komplett ist,<br>';
            echo 'kannst du es als Teamleader<br>';
            echo 'zu dem Turnier anmelden.<br>';
            echo '<br></center>';
        }
        else
        {
            if ( $team_pass1 != $team_pass2 )
            {
                echo '<br><center>';
                echo 'Sorry, aber das Passwort<br>';
                echo 'und die Passwortwiederhlung<br>';
                echo 'stimmen nicht �berein.<br><br>';
                echo 'Bitte versuch es nochmal.<br>';
                echo '<br></center>';
            }
            else
            {
                echo '<br><center>';
                echo 'Sorry, aber es gibt bereits<br>';
                echo 'ein Team mit gleichem Team-Namen<br>';
                echo 'oder gleicher NGL-ID.<br><br>';
                echo 'Bitte versuch es nochmal<br>';
                echo 'mit einem anderen Namen oder<br>';
                echo 'einer anderen NGL-ID<br>';
                echo '<br></center>';
            }
        }
    }
}


function show_creditmangel_single( $user_credits, $turnier_credits )
{
    echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
    echo '  <tr>';
    echo '    <td colspan="2" align="center">';
    echo '      <u>Sorry, du hast zu wenig Credits<br> f�r dieses Turnier!</u><br><br><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>deine Credits</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Kosten f�r dieses Turnier</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo ' - ' . $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '<hr width="100%">';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <font color="red">';
    echo '      <i>fehlende Credits</i>';
    echo '      </font>';
    echo '    </td>';
    echo '    <td align="right">';
    echo '      <font color="red">';
    echo        $user_credits - $turnier_credits;
    echo '      </font>';
    echo '    </td>';
    echo '  </tr>';
    echo '</table></center><br><br>';
}


function show_creditmangel_multi ( $user_credits, $turnier_credits )
{
    echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
    echo '  <tr>';
    echo '    <td colspan="2" align="center">';
    echo '      <u>Sorry, du hast zu wenig Credits<br> f�r dieses Turnier!</u><br><br><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>deine Credits</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo        $user_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <i>Kosten f�r dieses Turnier</i>';
    echo '    </td>';
    echo '    <td align="right">';
    echo ' - ' . $turnier_credits;
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '<hr width="100%">';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <font color="red">';
    echo '      <i>fehlende Credits</i>';
    echo '      </font>';
    echo '    </td>';
    echo '    <td align="right">';
    echo '      <font color="red">';
    echo        $user_credits - $turnier_credits;
    echo '      </font>';
    echo '    </td>';
    echo '  </tr>';
    echo '</table></center><br><br>';
}


function show_credits ( $user_id )
{
    global $db, $cl_txl;

    $anleitung  = 'Du kannst dich bis zu Beginn des Turniers an- und abmelden. ';
    $anleitung .= 'Bei einer Turnieranmeldung werden dir die Credits von deinem Konto abgezogen, bei einer Abmeldung ';
    $anleitung .= 'wieder gutgeschrieben. Der Wert in den Klammern hinter den Turnieren, zu denen du angemeldet bist, ';
    $anleitung .= 'sind die jeweiligen Credits, die dich die Anmeldung gekostet hat <br><br>';

    $res = mysqli_query($db, "SELECT credits FROM txl_lans WHERE lan_nr = $cl_txl AND com_user_id = $user_id");
    $row = mysqli_fetch_array($res);
    $credits = $row["credits"];

    echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '      deine Credits: ' . $credits . '<br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td colspan="2">';
    echo '      zu folgenden Turnieren hast du<br> dich schon angemeldet:<br><br>';
    echo '    </td>';
    echo '  </tr>';

    $res = mysqli_query($db, "SELECT txl_turniere.id as turnier_id, name, credits FROM txl_turniere, txl_turniere_teilnehmer WHERE txl_turniere.id = turnier_id AND teilnehmer_id = $user_id");
    while($row = mysqli_fetch_array($res))
    {
        echo '  <tr>';
        echo '    <td align="left">';
        echo '      <a class="link" href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $row["turnier_id"] . '">' . $row["name"] . '</a>';
        echo '    </td>';
        echo '    <td align="right" width="90">';
        echo '(' . $row["credits"] . ' Credits)';
        echo '    </td>';
        echo '  </tr>';
    }

    $res = mysqli_query($db, "SELECT txl_turniere.id as turnier_id, txl_turniere.name AS name, credits FROM txl_turniere, txl_turniere_team_teilnehmer, txl_turniere_teams WHERE txl_turniere.id = turnier_id AND txl_turniere_teams.id = team_id AND teilnehmer_id = $user_id");
    while($row = mysqli_fetch_array($res))
    {
        echo '  <tr>';
        echo '    <td align="left">';
        echo '      <a class="link" href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $row["turnier_id"] . '">' . $row["name"] . '</a>';
        echo '    </td>';
        echo '    <td align="right" width="90">';
        echo '(' . $row["credits"] . ' Credits)';
        echo '    </td>';
        echo '  </tr>';
    }

    echo '</table></center><br><br>';
}


function show_del_team( $user_id, $team_id, $leader )
{
	if ( $leader == 1 )
	{
		global $db;
		
	    $res = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_team_teilnehmer WHERE team_id = $team_id");
    	$row = mysqli_fetch_array($res);
    	$anzahl = $row["anzahl"];

  		if ( $anzahl <= 1 ) // Team besteht nur aus Leader
		{
			echo '<br><center>';
			echo 'Das Team wurde aufgel�st.<br><br>';
			echo 'Die Credits wurde dir wieder<br>';
			echo 'gut geschrieben.<br>';
			echo '</center><br>';
		}
		else // Team kann nicht aufgel�st werden, da noch Members vorhanden sind
		{
			echo '<br><center>';
			echo 'Sorry, du kannst dieses Team zur<br>';
			echo 'Zeit nicht aufl�sen, da du nicht<br>';
			echo 'der einzige in diesem Team bist.<br><br>';
			echo 'Du musst erst alle Members<br>';
			echo 'aus deinem Team kicken.<br><br>';
			echo '</center><br>';
		}
	}
	
	if ( $leader == 0 )
	{
		echo '<br><center>';
		echo 'Sorry, du bist nicht der<br>';
		echo 'Team-Leader. Nur Teamleader<br>';
		echo 'd�rfen Teams aufl�sen.<br>';
		echo '</center><br>';
	}
}


function show_error()
{
    echo '<br><br><center>Sorry, dein Unkostenbeitrag ist bei uns noch nicht eingegangen! Eine Turnieranmeldung ist erst nach eingegangener �berweisung m�glich.</center><br><br>';
}


function show_join_team( $user_id, $turnier_id, $team_id )
{
    global $db;

    if ( !isset($_POST["team_name"]) )
    {
        $res = mysqli_query($db, "SELECT id, name FROM txl_turniere_teams WHERE turnier_id = $turnier_id");

        echo '<form action="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_join" method="post">';
        echo '<br><center><table border="0" cellpadding="0" cellspacing="0">';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Team-Name: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <select name="team_name" size="1">';
        echo '        <option value="0">Team w�hlen</option>';

        while($row = mysqli_fetch_array($res))
        {
            $id   = $row["id"];
            $name = $row["name"];

            echo '        <option value="' . $id . '">' . $name . '</option>';
        }

        echo '      </select>';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td align="right">';
        echo '      Team-Passwort: ';
        echo '    </td>';
        echo '    <td align="left">';
        echo '      <input type="password" size="10" name="team_pass">';
        echo '    </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '    <td colspan="2" align="center">';
        echo '      <br><input type="submit" class="button" value="beitreten">';
        echo '    </td>';
        echo '  </tr>';
        echo '</table></center></form><br>';
    }
    else
    {
        if ( isset($_POST["team_name"]) ) $post_team_id = $_POST["team_name"];

		if ( fetch_team_id( $turnier_id , $user_id ) == $post_team_id )
		{
			$team_members = (count_team_members( $post_team_id )) - 1;
			$team_max_size = count_turnier_team_members( $turnier_id );
		}
		else
		{
			$team_members = count_team_members( $post_team_id );
			$team_max_size = count_turnier_team_members( $turnier_id );
		}

        if ( $team_id <= 0 )
        {
            if ( $post_team_id == 0 )
            {
    			echo '<br><center>';
    			echo 'Um einem Team beizutreten,<br>';
    			echo 'musst du das Team ausw�hlen<br>';
    			echo 'und das richtige Team-Passwort<br>';
    			echo 'eingeben.<br>';
    			echo '</center><br>';
    		}
    		elseif ( $team_members >= $team_max_size  )
   		    {
   		        echo '<br><center>';
                echo 'Du kannst diesem Team nicht mehr<br>';
                echo 'beitreten, da es bereits voll ist.<br><br>';
                echo 'Entweder du suchst dir ein neues<br>';
                echo 'Team oder der Team-Leader kickt<br>';
                echo 'ein Member.<br>';
                echo '</center><br>';
            }
    		elseif ( check_team_pw() == 1 )
   		    {
   		        echo '<br><center>';
                echo 'Du bist dem Team<br>';
                echo 'erfolgreich beigetreten.<br><br>';
                echo 'Sobald euer Team Komplett ist,<br>';
                echo 'kann der Team-Leader das Team<br>';
                echo 'zum Turnier anmelden.<br>';
                echo '</center><br>';
            }
            else
		    {
		        echo '<br><center>';
                echo 'Sorry, das von dir eingegebene<br>';
                echo 'Team-Passwort ist leider falsch.<br><br>';
                echo 'Du kannst es erneut versuchen<br>';
                echo 'oder den Team-Leader nach dem<br>';
                echo 'richtigen Passwort fragen.<br>';
                echo '</center><br>';
            }
		}
		else
		{
	        echo '<br><center>';
            echo 'Sorry, du bist bereits Mitglied<br>';
            echo 'eines anderen Teams.<br>';
            echo '</center><br>';
        }
    }
}


function show_leave_team( $user_id, $turnier_id , $team_id, $leader )
{
    if ( $leader == 0 && check_turnier_team( $turnier_id , $team_id, $user_id ) == 0 ) // wenn User ist kein Leader und Team ist noch nicht zum Turnier angemeldet, dann darf er das Team verlassen.
    {
        echo '<br><center>';
	    echo 'Du hast soeben das Team verlassen.<br><br>';
	    echo 'Die Credits wurden dir wieder<br>';
	    echo 'gut geschrieben.<br>';
	    echo '</center><br>';
    }
	elseif ( check_turnier_team( $turnier_id , $team_id, $user_id ) == 1 ) // wenn Team schon zum Turnier angemeldet ist, darf der User das Team nicht mehr verlassen
    {
        echo '<br><center>';
	    echo 'Du kannst dieses Team im Moment nicht<br>';
	    echo 'verlassen, da der Leader dieses Team<br>';
	    echo 'bereits zum Turnier angemeldet hat.<br><br>';
	    echo 'Dein Team-Leader wurde gerade<br>';
	    echo 'automatisch benachrichtigt, dass du<br>';
	    echo 'das Team verlassen m�chtest.<br><br>';
		echo 'Sobald dein Teamleader das Team vom<br>';
	    echo 'Turnier wieder abgemeldet hat, bekommst<br>';
	    echo 'du automatisch eine Benachrichtigung.<br>';
	    echo 'Dann kannst du das Team verlassen<br>';
	    echo '</center><br>';
    }
    else // wenn User der Leader des Teams ist, darf er es nicht verlassen. Er muss es aufl�sen.
    {
        echo '<br><center>';
	    echo 'Sorry, du kannst dieses Team<br>';
	    echo 'nicht verlassen, weil du der<br>';
        echo 'Team-Leader bist.<br><br>';
	    echo 'Du kannst dieses Team nur aufl�sen.';
	    echo '</center><br>';
    }
}


function show_kick_member( $turnier_id , $team_id, $user_id )
{
	global $db;
	
	if ( isset($_GET["kick_id"]) ) $kick_id = $_GET["kick_id"];

	$res = mysqli_query($db, "SELECT nick FROM txl_teilnehmer WHERE id = $kick_id");
	$row = mysqli_fetch_array($res);
	$nick = $row["nick"];

	if ( check_turnier_team( $turnier_id , $team_id, $user_id ) == 0 && check_team_leader( $team_id, $user_id ) == 1 && fetch_team_id( $turnier_id, $kick_id ) == -1 ) // Team ist nich zum Turnier angemeldet: Team-Member wird gekickt!
	{
		echo '<br><center>';
    	echo 'Du hast soeben<br><br>';
    	echo '<b>' . $nick . '</b><br><br>';
    	echo 'aus deinem Team gekickt.<br>';
    	echo '</center><br>';
    }
	elseif ( check_team_leader( $team_id, $user_id ) == 0 ) // User ist nicht Team-Leader: Fehler-Meldung
	{
		echo '<br><center>';
    	echo 'Sorry, aber du bist nicht der<br>';
    	echo 'Team-Leader. Nur Team-Leader<br>';
    	echo 'k�nnen ihre Team-Member kicken.<br>';
    	echo '</center><br>';
    }
	elseif ( check_turnier_team( $turnier_id , $team_id, $user_id ) == 1 && check_team_leader( $team_id, $user_id ) == 1 ) // Member kann nicht gekickt werden, da das Team bereits zum Turnier angemeldet ist
	{
		echo '<br><center>';
    	echo 'Sorry, du kannst <b>' . $nick . '</b><br>';
    	echo 'zur Zeit nicht aus deinen<br>';
    	echo 'Team kicken, weil dein Team<br>';
    	echo 'bereits zum Turnier angemeldet ist.<br><br>';
    	echo 'Du kannst dein Team jeder Zeit<br>';
    	echo 'abmelden und dann Team-Member<br>';
    	echo 'aus dem Team kicken.<br><br>';
    	echo 'Allerdings kannst du nur ein<br>';
    	echo 'Komplettes Team zum Turnier anmelden.<br><br>';
		echo 'Wenn dein Team bis zu Beginn des<br>';
		echo 'Turniers nicht angemeldet ist,<br>';
		echo 'k�nnt ihr nicht am Turnier teilnehmen.<br>';
    	echo '</center><br>';
    }
    elseif ( fetch_team_id( $turnier_id , $kick_id ) != -1 && check_team_leader( $team_id, $user_id ) == 1 ) // Member wurde nicht aus dem Team gekickt, weil der Leader und der Member nicht im selber Team sind: Einlauf f�r den Member
	{
		echo '<br><center>';
    	echo '<b><u>Warnung!</u></b><br><br>';
    	echo 'Die Manipulation der Browserzeile<br>';
    	echo 'wird den Admins sofort gemeldet!<br>';
    	echo '</center><br>';

		$text  = "User: $user_id (Team: " . fetch_team_id( $turnier_id, $user_id ) . ") hat versucht\n";
		$text .= "User: $kick_id (Team: " . fetch_team_id( $turnier_id, $kick_id ) . ") aus dem\n";
		$text .= "Team zu kicken.\n";

		pm( '1', '2', 'Manipulation am Turnier-System', $text );
		pm( '1', '3', 'Manipulation am Turnier-System', $text );
    }
    else // FEHLERCODE: show_kick_member: #00001
    {
		pm( '1', '2', 'BUG!', 'Datei: func_turnier.inc.php\nFEHLERCODE: show_kick_member: #00001' );
	}

}
	

function show_list_teams( $turnier_id )
{
    global $db;

// --------- ab hier gemeldete, vollst�ndige Teams ----------------

    echo '<br><table border="0" cellpadding="0" cellspacing="0" width="100%">';
    echo '  <tr>';
    echo '    <td align="center" colspan="2">';
    echo '      <b><u>gemeldete (komplette) Teams</u></b><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Team</b></font>';
    echo '    </td>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Members</b>';
    echo '    <td>';
    echo '    </td>';
    echo '  </tr>';

    $res = mysqli_query($db, "SELECT txl_turniere_teams.id AS tid, txl_turniere_team_teilnehmer.id as uid, name, ngl_id, teilnehmer_id, nick FROM txl_turniere_teams, txl_turniere_team_teilnehmer, txl_teilnehmer WHERE txl_turniere_teams.turnier_id = $turnier_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_team_teilnehmer.teilnehmer_id = txl_teilnehmer.id AND txl_turniere_teams.gemeldet = 1 ORDER BY txl_turniere_teams.id");
    while($row = mysqli_fetch_array($res))
    {
        $id            = $row["tid"];
        $name          = '<u>' . $row["name"] . '</u>';
        $ngl_id        = $row["ngl_id"];
        $teilnehmer_id = $row["teilnehmer_id"];
        $nick          = $row["nick"];

		if (isset ($letztes_team))
		{
	        if ( $letztes_team != $id )
	        {
	            echo '  <tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
	        }
	        else
	        {
	            $name = '&nbsp;';
	        }
	    }

        $letztes_team = $id;

        echo '  <tr>';
        echo '    <td align="center">';
        echo $name;
        echo '    </td>';
        echo '    <td align="center">';
        echo '<a class="link" href="index.php?action=user&id=' . $teilnehmer_id . '">' . $nick . '</a>';
        echo '    </td>';
        echo '  </tr>';
    }
    echo '</table><br>';

// --------- bis hier gemeldete Teams, vollst�ndige ----------------
// --------- ab hier nicht gemeldete, unvollst�ndige Teams ----------------

    echo '<br><table border="0" cellpadding="0" cellspacing="0" width="100%">';
    echo '  <tr>';
    echo '    <td align="center" colspan="2">';
    echo '      <b><u>noch nicht gemeldete Teams</u></b><br><br>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Team</b>';
    echo '    </td>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Members</b>';
    echo '    <td>';
    echo '    </td>';
    echo '  </tr>';

//    echo "SELECT txl_turniere_teams.id AS tid, name, ngl_id, teilnehmer_id, nick FROM txl_turniere_teams, txl_turniere_team_teilnehmer, txl_teilnehmer WHERE txl_turniere_teams.turnier_id = $turnier_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_team_teilnehmer.teilnehmer_id = txl_teilnehmer.id AND txl_turniere_teams.gemeldet = 0 ORDER BY name<br><br>";

    $res = mysqli_query($db, "SELECT txl_turniere_teams.id AS tid, name, wwcl_id, ngl_id, teilnehmer_id, nick FROM txl_turniere_teams, txl_turniere_team_teilnehmer, txl_teilnehmer WHERE txl_turniere_teams.turnier_id = $turnier_id AND txl_turniere_teams.id = txl_turniere_team_teilnehmer.team_id AND txl_turniere_team_teilnehmer.teilnehmer_id = txl_teilnehmer.id AND txl_turniere_teams.gemeldet = 0 ORDER BY name");
    while($row = mysqli_fetch_array($res))
    {
        $id            = $row["tid"];
        $name          = '<u>' . $row["name"] . '</u>';
        $ngl_id        = $row["ngl_id"];
        $teilnehmer_id = $row["teilnehmer_id"];
        $nick          = $row["nick"];

        if ( $letztes_team != $id )
        {
            echo '  <tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
        }
        else
        {
            $name = '&nbsp;';
        }

        $letztes_team = $id;

        echo '  <tr>';
        echo '    <td align="center">';
        echo $name;
        echo '    </td>';
        echo '    <td align="center">';
        echo '<a class="link" href="index.php?action=user&id=' . $teilnehmer_id . '">' . $nick . '</a>';
        echo '    </td>';
        echo '  </tr>';
    }
    echo '</table><br>';
// --------- bis hier nicht gemeldete, unvollst�ndige Teams ----------------
}


function show_my_team( $team_id, $turnier_id, $leader, $user_id )
{
    global $db;

    if ( $team_id <= 0 )
    {
        echo '<br><center>';
        echo 'Sorry, aber du bist bisher<br>';
        echo 'kein Mitglied eines Teams.';
        echo '</center><br><br>';
    }

    if ( $team_id >= 1 )
    {
        echo '<br><center><table border="0" cellpadding="0" cellspacing="0" width="90%">';
        echo '  <tr>';
        echo '    <td align="center" width="45%">';
        echo '<b>Nick</b>';
        echo '    </td>';
        echo '    <td align="center" width="45%">';
        echo '<b>Status</b>';
        echo '    </td>';

        if ( $leader == 1 )
        {
            echo '    <td align="center" width="10%">';
            echo '<b>kick</b>';
            echo '    </td>';
        }

        echo '  </tr>';
        echo '  <tr>';
        echo '    <td>';
        echo '&nbsp;';
        echo '    </td>';
        echo '    <td>';
        echo '&nbsp;';
        echo '    </td>';

        if ( $leader == 1 )
        {
            echo '    <td>';
            echo '&nbsp;';
            echo '    </td>';
        }

        echo '  </tr>';

        $res = mysqli_query($db, "SELECT teilnehmer_id, leader, nick FROM txl_turniere_team_teilnehmer, txl_turniere_teams, txl_teilnehmer WHERE txl_turniere_team_teilnehmer.team_id = $team_id AND txl_turniere_team_teilnehmer.team_id = txl_turniere_teams.id AND txl_turniere_team_teilnehmer.teilnehmer_id = txl_teilnehmer.id ORDER BY txl_turniere_team_teilnehmer.id");
        while($row = mysqli_fetch_array($res))
        {
            $teilnehmer_id = $row["teilnehmer_id"];
            if ( $row["leader"] == 1 ) $team_leader = 'Leader';
            if ( $row["leader"] == 0 ) $team_leader = 'Member';
            $nick = $row["nick"];

            echo '  <tr>';
            echo '    <td align="center" width="45%">';
            echo '<a class="link" href="index.php?action=user&id=' . $teilnehmer_id . '">' . $nick . '</a>';
            echo '    </td>';
            echo '    <td align="center" width="45%">';
            echo $team_leader;
            echo '    </td>';

            if ( $leader == 1 && $row["leader"] == 0 )
            {
                echo '    <td align="center" width="10%">';
                echo '<a class="link" title="' . $nick . ' aus dem Team kicken" href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=kick_member&kick_id=' . $teilnehmer_id . '"><b>X</b></a>';
                echo '    </td>';
            }
            else
            {
                echo '    <td>';
                echo '&nbsp;';
                echo '    </td>';
            }

            echo '  </tr>';
        }
        echo '</table></center><br>';
    }

    if ( $team_id <= 0 && $leader == 1 )
    {
        echo 'FEHLER!<br>';
    }
}


function show_turnier_single( $turnier_id, $angemeldet, $user_id, $user_status )
{
    global $db, $rechte;

    $res_anzahl = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teilnehmer WHERE turnier_id = $turnier_id");
    $row_anzahl = mysqli_fetch_array($res_anzahl);

    $turnier_teilnehmer = $row_anzahl["anzahl"];

    $res = mysqli_query($db, "SELECT * FROM txl_turniere, txl_teilnehmer WHERE txl_turniere.id = $turnier_id AND txl_turniere.orga_id = txl_teilnehmer.id");
    $row = mysqli_fetch_array($res);

    $turnier_name      		= $row["name"];
    $turnier_credits   		= $row["credits"];
    $turnier_starttime 		= $row["starttime"];
    $turnier_endtime   		= $row["endtime"];
    $turnier_ngl       		= $row["ngl"];
    $turnier_elimination	= $row["double_elimination"];
    $turnier_orga_id        = $row["orga_id"];
    $turnier_orga_nick      = $row["nick"];
	$turnier_status         = $row["status"];

    if ( strftime( '%w',$turnier_starttime ) == 1 ) $turnier_starttag = "Montag";
    if ( strftime( '%w',$turnier_starttime ) == 2 ) $turnier_starttag = "Dienstag";
    if ( strftime( '%w',$turnier_starttime ) == 3 ) $turnier_starttag = "Mittwoch";
    if ( strftime( '%w',$turnier_starttime ) == 4 ) $turnier_starttag = "Donnerstag";
    if ( strftime( '%w',$turnier_starttime ) == 5 ) $turnier_starttag = "Freitag";
    if ( strftime( '%w',$turnier_starttime ) == 6 ) $turnier_starttag = "Samstag";
    if ( strftime( '%w',$turnier_starttime ) == 0 ) $turnier_starttag = "Sonntag";

    if ( strftime( '%w',$turnier_endtime ) == 1 ) $turnier_endtag = "Montag";
    if ( strftime( '%w',$turnier_endtime ) == 2 ) $turnier_endtag = "Dienstag";
    if ( strftime( '%w',$turnier_endtime ) == 3 ) $turnier_endtag = "Mittwoch";
    if ( strftime( '%w',$turnier_endtime ) == 4 ) $turnier_endtag = "Donnerstag";
    if ( strftime( '%w',$turnier_endtime ) == 5 ) $turnier_endtag = "Freitag";
    if ( strftime( '%w',$turnier_endtime ) == 6 ) $turnier_endtag = "Samstag";
    if ( strftime( '%w',$turnier_endtime ) == 0 ) $turnier_endtag = "Sonntag";

	if (isset($turnier_wwcl))
	{
    	if ( $turnier_wwcl == 0 ) $turnier_wwcl = 'keine Unterst�tzung';
    	if ( $turnier_wwcl == 1 ) $turnier_wwcl = 'WWCL-Unterst�tzung';
    }

    if ( $turnier_ngl == 0 ) $turnier_ngl = 'keine Unterst�tzung';
    if ( $turnier_ngl == 1 ) $turnier_ngl = 'Gold';
    if ( $turnier_ngl == 2 ) $turnier_ngl = 'Silber';
    if ( $turnier_ngl == 3 ) $turnier_ngl = 'Bronze';

	if ( $turnier_elimination == 0 ) $turnier_elimination = '<li>Single-Elimination';
	elseif ( $turnier_elimination == 1 ) $turnier_elimination = '<li>Double-Elimination';
	elseif ( $turnier_elimination == -1 ) $turnier_elimination = '';

    echo '<table border="1" cellpadding="3" cellspacing="1" width="300">';
    echo '  <tr>';
    echo '    <td align="center">';
    echo '      <b>' . $turnier_name . '</b>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <br>';
    echo '      <ul type="circle">';
    echo '        <li>Start: ' . $turnier_starttag . " " . strftime( "%H:%M",$turnier_starttime );
    echo '        <li>Ende: ' . $turnier_endtag . " " . strftime( "%H:%M",$turnier_endtime );
    echo '        <li>Kosten: ' . $turnier_credits . " Credits";
    echo '        <li>NGL: ' . $turnier_ngl;
    echo          $turnier_elimination;
    echo '        <li>bisher angemeldet: ' . $turnier_teilnehmer . " Teilnehmer";
    echo '      </ul>';
    echo '    </td>';
    echo '  </tr>';

	if ( $rechte[1] == 1) // erste Box: ("Frage an den Turnier-Orga"), sichtbar wenn eingeloggt
	{
		echo '  <tr>';
	    echo '    <td width="30%" align="center" valign="center">';
		echo '      <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '" class="link">Infos</a>';
	    echo '    </td>';
		echo '  </tr>';
	    echo '  <tr>';
    	echo '    <td align="center">';
		echo '      <a href="index.php?action=pm&mod=write&to=' . $turnier_orga_id . '">Frage an den Turnier-Orga ( ' . $turnier_orga_nick . ' )</a>';
		echo '    </td>';
		echo '  </tr>';
	}
	
	echo '  <tr>'; // zweite Box: ("zur�ck zur Turnierliste"), immer sichtbar
	echo '    <td align="center">';
    echo '      <a href="index.php?action=lan_turnier&mod=turnierliste">zur�ck zur Turnierliste</a>';
	echo '    </td>';
	echo '  </tr>';

	if ($turnier_status == 1) // dritte Box: Option zum Ab- bzw. Anmelden zum Turnier
	{
		echo '  <tr>';
		echo '    <td align="center">';
	    if ( check_turnier_anmeldung($turnier_id, $user_id) == 0 && $user_status >= 2 ) echo '<a href="index.php?action=lan_turnier&mod=infos&submod=anmelden&turnier_id=' . $turnier_id . '" class="link">du bist noch nicht angemeldet --> anmelden</a>';
    	if ( check_turnier_anmeldung($turnier_id, $user_id) == 1 && $user_status >= 2 ) echo '<a href="index.php?action=lan_turnier&mod=infos&submod=abmelden&turnier_id=' . $turnier_id . '" class="link">du bist bereits angemeldet --> abmelden</a>';
		echo '    </td>';
		echo '  </tr>';
	}

	if ($turnier_status >= 1) // vierte Box: ("Teilnehmerliste, Turnier-News")
	{
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <table border="0" cellspacing="0" cellpadding="0" width="100%">';
		echo '        <tr>';
		echo '          <td align="left">';
	    echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_tnews&id=' . $turnier_id . '" class="link">Turnier-News</a>';
		echo '          </td>';
		echo '          <td align="right">';
		echo '            <a href="index.php?action=lan_turnier&mod=infos&submod=teilnehmerliste&turnier_id=' . $turnier_id . '" class="link">Teilnehmerliste</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '          </td>';
		echo '        </tr>';
		echo '      </table>';
		echo '    </td>';
		echo '  </tr>';
	}

	if ($turnier_status == 2 || $turnier_status == 3) // f�nfte Box: ("Turnier-Baum, aktuelle Runde"), wird bei Turnier-Status 2 || 3 angezeigt
	{
		$turnier = new turnier;
		$turnier->init($turnier_id);
		
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <table border="0" cellspacing="0" cellpadding="0" width="100%">';
		echo '        <tr>';
		echo '          <td align="left">';
	    echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_tbaum&id=' . $turnier_id . '">Turnier-Baum</a>';
		echo '          </td>';
		echo '          <td align="right">';
		echo '            <a href="index.php?action=lan_turnier_runde&runde=' . $turnier->id .',' . $turnier->aktrunde() . ',' . $turnier->double_el . '">aktuelle Runde</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '          </td>';
		echo '        </tr>';
		echo '      </table>';
		echo '    </td>';
		echo '  </tr>';
	}
	
	if ($rechte[8] == 1 && $turnier_status == 2) // sechste Box: Runde generieren lassen (nur von TXL-Turnier-Orgas ausf�hrbar und sichtbar)
	{
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <a href="index.php?action=lan_turnier_runde&gen=' . $turnier_id . '" class="link">n�chste Runde generieren</a>';
		echo '    </td>';
		echo '  </tr>';
	}

	echo '</table>';
}




function show_turnier_multi ( $turnier_id , $user_id, $user_status, $team_id, $team_gemeldet )
{
    global $db, $rechte;
/*
    echo "turnier_id: " . $turnier_id . "<br>";
    echo "user_id: " . $user_id . "<br>";
    echo "user_status: " . $user_status . "<br>";
    echo "team_id: " . $team_id . "<br>";
    echo "team_gemeldet: " . $team_gemeldet . "<br><br>";
*/
    $res_anzahl = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE turnier_id = $turnier_id AND gemeldet = 1");
    $row_anzahl = mysqli_fetch_array($res_anzahl);

    $turnier_teams = $row_anzahl["anzahl"];

    $res = mysqli_query($db, "SELECT * FROM txl_turniere, txl_teilnehmer WHERE txl_turniere.id = $turnier_id AND txl_turniere.orga_id = txl_teilnehmer.id");
    $row = mysqli_fetch_array($res);

    $turnier_name      		= $row["name"];
    $turnier_credits   		= $row["credits"];
    $turnier_starttime 		= $row["starttime"];
    $turnier_endtime   		= $row["endtime"];
    $turnier_wwcl      		= $row["wwcl"];
    $turnier_ngl       		= $row["ngl"];
    $turnier_elimination	= $row["double_elimination"];
    $turnier_orga_id        = $row["orga_id"];
    $turnier_orga_nick      = $row["nick"];
	$turnier_status         = $row["status"];


    if ( strftime( '%w',$turnier_starttime ) == 1 ) $turnier_starttag = "Montag";
    if ( strftime( '%w',$turnier_starttime ) == 2 ) $turnier_starttag = "Dienstag";
    if ( strftime( '%w',$turnier_starttime ) == 3 ) $turnier_starttag = "Mittwoch";
    if ( strftime( '%w',$turnier_starttime ) == 4 ) $turnier_starttag = "Donnerstag";
    if ( strftime( '%w',$turnier_starttime ) == 5 ) $turnier_starttag = "Freitag";
    if ( strftime( '%w',$turnier_starttime ) == 6 ) $turnier_starttag = "Samstag";
    if ( strftime( '%w',$turnier_starttime ) == 0 ) $turnier_starttag = "Sonntag";

    if ( strftime( '%w',$turnier_endtime ) == 1 ) $turnier_endtag = "Montag";
    if ( strftime( '%w',$turnier_endtime ) == 2 ) $turnier_endtag = "Dienstag";
    if ( strftime( '%w',$turnier_endtime ) == 3 ) $turnier_endtag = "Mittwoch";
    if ( strftime( '%w',$turnier_endtime ) == 4 ) $turnier_endtag = "Donnerstag";
    if ( strftime( '%w',$turnier_endtime ) == 5 ) $turnier_endtag = "Freitag";
    if ( strftime( '%w',$turnier_endtime ) == 6 ) $turnier_endtag = "Samstag";
    if ( strftime( '%w',$turnier_endtime ) == 0 ) $turnier_endtag = "Sonntag";

    if ( $turnier_wwcl == 0 ) $turnier_wwcl = 'keine Unterst�tzung';
    if ( $turnier_wwcl == 1 ) $turnier_wwcl = 'WWCL-Unterst�tzung';

    if ( $turnier_ngl == 0 ) $turnier_ngl = 'keine Unterst�tzung';
    if ( $turnier_ngl == 1 ) $turnier_ngl = 'Gold';
    if ( $turnier_ngl == 2 ) $turnier_ngl = 'Silber';
    if ( $turnier_ngl == 3 ) $turnier_ngl = 'Bronze';

	if ( $turnier_elimination == -1 ) $turnier_elimination = '';
	if ( $turnier_elimination == 0 ) $turnier_elimination = '<li>Single-Elimination';
	if ( $turnier_elimination == 1 ) $turnier_elimination = '<li>Double-Elimination';

    echo '<table border="1" cellpadding="3" cellspacing="1" width="300">';
    echo '  <tr>';
    echo '    <td align="center">';
    echo '      <b>' . $turnier_name . '</b>';
    echo '    </td>';
    echo '  </tr>';
    echo '  <tr>';
    echo '    <td align="left">';
    echo '      <br>';
    echo '      <ul type="circle">';
    echo '        <li>Start: ' . $turnier_starttag . " " . strftime( "%H:%M",$turnier_starttime );
    echo '        <li>Ende: ' . $turnier_endtag . " " . strftime( "%H:%M",$turnier_endtime );
    echo '        <li>Kosten: ' . $turnier_credits . " Credits";
    echo '        <li>NGL: ' . $turnier_ngl;
    echo          $turnier_elimination;
    if ( $turnier_teams == 1 ) echo '        <li>bisher angemeldet: ' . $turnier_teams . ' Team';
    if ( $turnier_teams != 1 ) echo '        <li>bisher angemeldet: ' . $turnier_teams . ' Teams';
    echo '      </ul>';
    echo '    </td>';
    echo '  </tr>';
	if ( $rechte[1] == 1) // erste Box: ("Frage an den Turnier-Orga"), sichtbar wenn eingeloggt
	{
		echo '  <tr>';
	    echo '    <td width="30%" align="center" valign="center">';
		echo '      <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '" class="link">Infos</a>';
	    echo '    </td>';
		echo '  </tr>';
	    echo '  <tr>';
    	echo '    <td align="center">';
		echo '      <a href="index.php?action=pm&mod=write&to=' . $turnier_orga_id . '">Frage an den Turnier-Orga ( ' . $turnier_orga_nick . ' )</a>';
		echo '    </td>';
		echo '  </tr>';
	}

	echo '  <tr>'; // zweite Box: ("zur�ck zur Turnierliste"), immer sichtbar
	echo '    <td align="center">';
    echo '      <a href="index.php?action=lan_turnier&mod=turnierliste">zur�ck zur Turnierliste</a>';
	echo '    </td>';
	echo '  </tr>';


	if ($turnier_status == 1) // dritte Box: Option zum Ab- bzw. Anmelden zum Turnier
	{
		echo '  <tr>';
		echo '    <td align="center">';
	    echo '      <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=myteam">mein Team</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '    </td>';
		echo '  </tr>';
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <table border="0" cellspacing="0" cellpadding="0" width="100%">';
		echo '        <tr>';
		echo '          <td align="left">';
	    if ( fetch_team_id( $turnier_id , $user_id ) <= 0 ) echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_create">Team erstellen</a>';
    	if ( fetch_team_id( $turnier_id , $user_id ) >= 1 && check_team_leader( $team_id, $user_id ) == 1 ) echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_del">Team aufl�sen</a>';
		echo '          </td>';
		echo '          <td align="right">';
	    if ( fetch_team_id( $turnier_id , $user_id ) <= 0 ) echo '            <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_join">Team beitreten</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
   		if ( fetch_team_id( $turnier_id , $user_id ) >= 1 && check_team_leader( $team_id, $user_id ) == 0 ) echo '            <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=team_leave">Team verlassen</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '          </td>';
		echo '        </tr>';
		echo '      </table>';
		echo '    </td>';
		echo '  </tr>';
	    if ( count_team_members( $team_id ) == count_turnier_team_members( $turnier_id ) && check_team_leader( $team_id, $user_id ) == 1 )
	    {
	        echo '      <table border="1" cellpadding="0" cellspacing="0" width="100%"><tr><td>';
	        echo '      <table border="0" cellpadding="1" cellspacing="1" width="100%">';
	        echo '        <tr>';
	        echo '          <td colspan="2" align="center" valign="center">';
	        if ( check_turnier_team( $turnier_id , $team_id, $user_id ) <= 0 ) echo '            <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=tournament_join">komplettes Team zum Turnier anmelden</a><br>';
	        if ( check_turnier_team( $turnier_id , $team_id, $user_id ) == 1 ) echo '            <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '&submod=tournament_leave">Team vom Turnier abmelden</a><br>';
	        echo '          </td>';
	        echo '        </tr>';
	        echo '      </table>';
	        echo '      </td></tr></table>';
	    }
	}


// infos: eventuell noch einbauen
/*
    echo '          <td width="30%" align="center" valign="center">';
	echo '            <a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '" class="link">Infos</a>';
    echo '          </td>';
    echo '          <td width="35%" align="right" valign="center">';
    echo '          </td>';
    echo '        </tr>';
    echo '      </table>';
    echo '      </td></tr></table>';
*/

	if ($turnier_status >= 1) // vierte Box: ("Teilnehmerliste, Turnier-News")
	{
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <table border="0" cellspacing="0" cellpadding="0" width="100%">';
		echo '        <tr>';
		echo '          <td align="left">';
	    echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_tnews&id=' . $turnier_id . '">Turnier-News</a>';
		echo '          </td>';
		echo '          <td align="right">';
		echo '            <a href="index.php?action=lan_turnier&mod=infos&submod=teilnehmerliste&turnier_id=' . $turnier_id . '">Teilnehmerliste</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '          </td>';
		echo '        </tr>';
		echo '      </table>';
		echo '    </td>';
		echo '  </tr>';
	}

	if ($turnier_status == 2 || $turnier_status == 3) // f�nfte Box: ("Turnier-Baum, aktuelle Runde"), wird bei Turnier-Status 2 || 3 angezeigt
	{
		$turnier = new turnier;
		$turnier->init($turnier_id);

		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <table border="0" cellspacing="0" cellpadding="0" width="100%">';
		echo '        <tr>';
		echo '          <td align="left">';
	    echo '            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?action=lan_tbaum&id=' . $turnier_id . '">Turnier-Baum</a>';
		echo '          </td>';
		echo '          <td align="right">';
		echo '            <a href="index.php?action=lan_turnier_runde&runde=' . $turnier->id .',' . $turnier->aktrunde() . ',' . $turnier->double_el . '">aktuelle Runde</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		echo '          </td>';
		echo '        </tr>';
		echo '      </table>';
		echo '    </td>';
		echo '  </tr>';
	}


	if ($rechte[8] == 1 && $turnier_status == 2) // sechste Box: Runde generieren lassen (nur von TXL-Turnier-Orgas ausf�hrbar und sichtbar)
	{
		echo '  <tr>';
		echo '    <td align="center">';
		echo '      <a href="index.php?action=lan_turnier_runde&gen=' . $turnier_id . '">n�chste Runde generieren</a>';
		echo '    </td>';
		echo '  </tr>';
	}

	echo '</table>';

}


function show_turnier_teilnehmer( $turnier_id )
{
    global $db;

//    echo "SELECT txl_teilnehmer.id AS tid,nick,clan,teilnehmer_id AS turnid,complete,clan_name FROM txl_teilnehmer,txl_turniere_teilnehmer,txl_clan WHERE txl_teilnehmer.id = txl_turniere_teilnehmer.teilnehmer_id AND txl_clan.clan_id = txl_teilnehmer.clan AND complete = 1 AND txl_turniere_teilnehmer.turnier_id = $turnier_id ORDER BY nick<br>";

    echo '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
    echo '  <tr>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Teilnehmer</b>';
    echo '    </td>';
    echo '    <td width="50%" align="center">';
    echo '      <b>Clan</b>';
    echo '    </td>';
    echo '  </tr>';

#$res = mysqli_query($db, "SELECT txl_teilnehmer.id AS tid, nick, clan, teilnehmer_id AS turnid, clan_name FROM txl_teilnehmer, txl_turniere_teilnehmer LEFT OUTER JOIN txl_clan ON txl_clan.clan_id = txl_teilnehmer.clan WHERE txl_teilnehmer.id = txl_turniere_teilnehmer.teilnehmer_id AND txl_turniere_teilnehmer.turnier_id = $turnier_id ORDER BY nick");
#echo "SELECT txl_teilnehmer.id AS tid, nick, clan, teilnehmer_id AS turnid, clan_name FROM txl_teilnehmer, txl_turniere_teilnehmer LEFT OUTER JOIN txl_clan ON txl_clan.clan_id = txl_teilnehmer.clan WHERE txl_teilnehmer.id = txl_turniere_teilnehmer.teilnehmer_id AND txl_turniere_teilnehmer.turnier_id = $turnier_id ORDER BY nick";

$res = mysqli_query($db, "SELECT txl_teilnehmer.id AS tid, nick, clan, teilnehmer_id AS turnid, clan_name FROM txl_turniere_teilnehmer LEFT JOIN txl_teilnehmer ON txl_teilnehmer.id = txl_turniere_teilnehmer.teilnehmer_id LEFT OUTER JOIN txl_clan ON txl_clan.clan_id = txl_teilnehmer.clan WHERE txl_turniere_teilnehmer.turnier_id = $turnier_id ORDER BY nick");

    while ($row = mysqli_fetch_array($res))
    {
        $nick_id   = $row["tid"];
        $nick_name = $row["nick"];
        $clan_id   = $row["clan"];
        $clan_name = $row["clan_name"];

#		echo '<tr><td bgcolor="red">nick_id: ' . $nick_id . '<br>nick_name: ' . $nick_name . '<br>clan_id: ' . $clan_id . '<br>clan_name: ' . $clan_name . '<br><br><br></td><td>tedz</td></tr>';

        echo '  <tr>';
        echo '    <td width="50%" align="center">';
        echo '      <a href="index.php?action=user&id=' . $nick_id . '">' . $nick_name . '</a>';
        echo '    </td>';
        echo '    <td width="50%" align="center">';
        echo '      <a href="index.php?action=com_clan&cid=' . $clan_id . '">' . $clan_name . '</a>';
        echo '    </td>';
        echo '  </tr>';
    }
    echo '</table>';
}


function show_turnierliste ( $turnier_id, $turnier_icon, $turnier_name, $turnier_starttime, $turnier_endtime, $turnier_credits, $turnier_ngl, $turnier_wwcl, $turnier_anzahl, $turnier_status, $user_id, $bgcolor )
{
    global $db, $rechte, $images;

    $res_anzahl_teilnehmer = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teilnehmer WHERE turnier_id = $turnier_id");
    $row_anzahl_teilnehmer = mysqli_fetch_array($res_anzahl_teilnehmer);
    $turnier_teilnehmer = $row_anzahl_teilnehmer["anzahl"] . ' Teilnehmer';

    $res_anzahl_teams = mysqli_query($db, "SELECT count(*) AS anzahl FROM txl_turniere_teams WHERE turnier_id = $turnier_id");
    $row_anzahl_teams = mysqli_fetch_array($res_anzahl_teams);
    if ( $row_anzahl_teams["anzahl"] == 1 )$turnier_teams = $row_anzahl_teams["anzahl"] . ' Team';
    if ( $row_anzahl_teams["anzahl"] != 1 )$turnier_teams = $row_anzahl_teams["anzahl"] . ' Teams';

	if ( $turnier_ngl == 0 )
	{
		$turnier_ngl = '';
	}
	elseif ( $turnier_ngl == 1 )
	{
		$turnier_ngl = '<img src="http://' . $images . '/turniere/ngl_gold.gif" border="0" alt="NGL Gold">';
	}
	elseif ( $turnier_ngl == 2 )
	{
		$turnier_ngl = '<img src="http://' . $images . '/turniere/ngl_silber.gif" border="0" alt="NGL Silber">';
	}
	elseif ( $turnier_ngl == 3 )
	{
		$turnier_ngl = '<img src="http://' . $images . '/turniere/ngl_bronze.gif" border="0" alt="NGL Bronze">';
	}

	if ( $turnier_wwcl == 1 )
	{
		$turnier_wwcl = "WWCL";
	}
	else
	{
		$turnier_wwcl = "-";
	}


 	if ( $turnier_status == 1 )
	{
		if ( check_turnier_single($user_id, $turnier_id) || check_turnier_multi($user_id, $turnier_id) )
		{
			$turnier_status = '<img src="http://' . $images . '/turniere/t_angemeldet.gif" border="0" alt="angemeldet">';
		}
		else
		{
			$turnier_status = '<img src="http://' . $images . '/turniere/t_abgemeldet.gif" border="0" alt="nicht angemeldet">';
		}
	}
	elseif ( $turnier_status >= 2 )
	{
		$turnier_status = '<a href="index.php?action=lan_tbaum&id=' . $turnier_id . '"><img src="http://' . $images . '/turniere/icon_turnierbaum.gif" border="0" alt="Turnierbaum anzeigen">';
	}
	else
	{
		$turnier_status = '';
	}

    if ( strftime( '%w',$turnier_starttime ) == 1 ) $turnier_starttime = "Montag, "     . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 2 ) $turnier_starttime = "Dienstag, "   . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 3 ) $turnier_starttime = "Mittwoch, "   . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 4 ) $turnier_starttime = "Donnerstag, " . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 5 ) $turnier_starttime = "Freitag, "    . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 6 ) $turnier_starttime = "Samstag, "    . strftime( "%H:%M",$turnier_starttime );
    if ( strftime( '%w',$turnier_starttime ) == 0 ) $turnier_starttime = "Sonntag, "    . strftime( "%H:%M",$turnier_starttime );

    if ( strftime( '%w',$turnier_endtime ) == 1 ) $turnier_endtime = "Montag, "     . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 2 ) $turnier_endtime = "Dienstag, "   . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 3 ) $turnier_endtime = "Mittwoch, "   . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 4 ) $turnier_endtime = "Donnerstag, " . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 5 ) $turnier_endtime = "Freitag, "    . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 6 ) $turnier_endtime = "Samstag, "    . strftime( "%H:%M",$turnier_endtime );
    if ( strftime( '%w',$turnier_endtime ) == 0 ) $turnier_endtime = "Sonntag, "    . strftime( "%H:%M",$turnier_endtime );

	if ( $bgcolor == '' ) echo '  <tr>';
	else echo '  <tr bgcolor="' . $bgcolor . '">';

	echo '    <td align="rigth">';
	if ( $turnier_icon != "" ) echo '<img src="' . $turnier_icon . '" border="0">';
	if ( $turnier_icon == "" ) echo '&nbsp;';
   	echo '    </td>';
	echo '    <td align="left">';
	echo '<a href="index.php?action=lan_turnier&mod=infos&turnier_id=' . $turnier_id . '" class="link">' . $turnier_name . '</a>';
   	echo '    </td>';
    echo '    <td align="center">';
 	echo $turnier_credits;
    echo '    </td>';
    echo '    <td align="center">';
 	echo $turnier_ngl;
    echo '    </td>';
    echo '    <td align="center">';
 	echo '<i>' . $turnier_starttime . '</i>';
    echo '    </td>';
    echo '    <td align="left">';
 	if ( $turnier_anzahl == 1 ) echo $turnier_teilnehmer;
 	if ( $turnier_anzahl >= 2 ) echo $turnier_teams;
    echo '    </td>';
    echo '    <td align="center">';
 	echo $turnier_status;
    echo '    </td>';

	if ( $rechte[4] == 1 && $rechte[8] == 1 )
	{
		echo '<td align="center">';
 		echo '<a href="index.php?action=edit_turnier&turnier_id=' . $turnier_id . '"><img src="http://' . $images . '/edit.gif" border="0" alt="Turnierdaten �ndern"></a>';
		echo '</td>';
//		echo '<td align="center">';
//		echo '<a href="index.php?action=lan_turnier&mod=turnierliste&submod=del&turnier_id=' . $turnier_id . '"><img src="http://' . $images . '/delete.gif" border="0" alt="Turnier l�schen"></a>';
//		echo '</td>';
	}

    echo '  </tr>';
}
?>
